LaunchXiiLang  {

	var projectname, key, field, keyfield;
	var win, button, button2;
	var ixilogo;
	
	*new { 
		^super.new.initGUIXii;
	}

	initGUIXii {		
		
		projectname = "default";
		key = "C";

		ixilogo = [ // the ixi logo
			Point(1,7), Point(8, 1), Point(15,1), Point(15,33),Point(24, 23), Point(15,14), 
			Point(15,1), Point(23,1),Point(34,13), Point(45,1), Point(61,1), Point(66,6), 
			Point(66,37), Point(59,43), Point(53,43), Point(53,12), Point(44,22), Point(53,33), 
			Point(53,43), Point(42,43), Point(34,32),Point(24,43), Point(7,43), Point(1,36), Point(1,8)
			];

		win = SCWindow.new("ixi lang launcher", Rect(310,410, 500, 200)).front;

		field = TextField(win, Rect(10, 150, 100, 20))
			.string_("project name")
			.align_(\center);
		
		keyfield = TextField(win, Rect(120, 150, 30, 20))
			.string_("C")
			.align_(\center);

		SCStaticText(win, Rect(190, 10, 350, 120))
			.string_("Put your soundfiles into a folder within the sounds folder.\nThe name you give that folder becomes the project name. \nYou can map the keys on your keyboard to sound file names \nusing the keyMappings.ixi file.\n\nIf you just want to test, without making a new project, leave the \n'project name' field as it is and press 'start session'.")
			.font_(Font("Helvetica", 10));

		button = SCButton(win, Rect(200, 150, 100, 20));
		button.states = [
			["start session", Color.black, Color.gray]
		];
		button.action = {
			if(field.value == "project name", {
				\ooo.postln;
				projectname = "default";
				XiiLang.new(projectname, key, true);
			}, {
				projectname = field.value;
				XiiLang.new(projectname, key, true);
			});
		};
		
		button2 = SCButton(win, Rect(310, 150, 100, 20));
		button2.states = [
			["ixi lang help", Color.black, Color.gray]
		];
		button2.action = {
			 "open XiiLang.html".unixCmd;
		};


		win.drawHook = {
			GUI.pen.color = Color.new255(255, 102, 0, 160);
			GUI.pen.width = 3;
			GUI.pen.translate(40,40);
			GUI.pen.scale(1.2,1.2);
			GUI.pen.moveTo(1@7);
			ixilogo.do({arg point;
				GUI.pen.lineTo(point+0.5);
			});
			GUI.pen.stroke;
		};


	}

}

